# This program demonstrates how to pass lists to a function as arguments.
# In this case, list_x and list_y are passed to the prodList() function where
# the first value of each list is multiplied together followed by the
# second and third values respectively. Each product is added to a running
# total that is then returned to the calling function.

# Because the prodList() function needs to accept two lists from the calling
# function, we'll include these as parameters x and y.
def prodList(x, y):
    # Let's initialize a variable to keep a running total.
    sum = 0
    # We'll use a For loop to iterate through our lists. Since I've hard-coded
    # the lists to the same length, I'm going to be lazy and use the length of
    # list x as the range. If you weren't sure which list is longer, how could
    # you modify this program to determine which list is longer for you and use
    # that as the range instead?
    for index in range(len(x)):
        # Let's multiply the value stored in each list at the current index and
        # add the result to our running total. Note the use of the shorthand +=
        # operator. What is another way we could build this statement?
        sum += x[index] * y[index]
    # Finally, we'll return the total to the calling function.
    return sum

def main():
    # Because I'm lazy, I'm just going to hard-code a couple of lists, making sure
    # that they are the same length.
    list_x = [2, 3, 1.5]
    list_y = [1.5, 2, 4]
    # Now I'll call the prodList() function from inside the print statement using
    # list_x and list_y as arguments to pass their contents to the prodList() function.
    print ("The sum of the inner products is" , prodList(list_x, list_y))

if __name__=='__main__':
    main()
